﻿using System.Collections;
using System.Collections.Generic;
using System.Linq;
using TMPro;
using UnityEngine;
using UnityEngine.UI;

//CarSelectionMenu handles the car selection UI in the in-game garages
public class CarSelectionMenu : MonoBehaviour
{
    //UI elements
    public GameObject CarSelectionUI;
    public CarSelector CarSelector;

    private bool _IsShowing;

    void Start()
    {
        _IsShowing = false;

        CarSelectionUI.SetActive(true);
        CarSelector.CancelButton.Button.onClick.AddListener(OnCancelButtonClick);
        CarSelectionUI.SetActive(false);
    }

    /// <summary>
    /// Handler for clicking the cancel button
    /// </summary>
    private void OnCancelButtonClick()
    {
        //Hide the UI, set the game state and begin playing again
        CarSelectionUI.SetActive(false);
        GameManager.Instance.SetGameState(Constants.GameState.Playing);
        Time.timeScale = 1.0f;
        _IsShowing = false;
        GameManager.Instance.RestartAmbientMusic();
    }
}
